/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.References;

public class DataFixHandler {
    private static final Set<String> KEYCARD_HOLDER_OR_DISGUISE_MODULE = Set.of("securitycraft:keycard_holder", "securitycraft:disguise_module");
    private static final Set<String> KEYCARDS = Set.of("securitycraft:keycard_lv1", "securitycraft:keycard_lv2", "securitycraft:keycard_lv3", "securitycraft:keycard_lv4", "securitycraft:keycard_lv5");
    private static final Set<String> REINFORCERS = Set.of("securitycraft:universal_block_reinforcer_lvl2", "securitycraft:universal_block_reinforcer_lvl3");
    private static final Set<String> LIST_MODULES = Set.of("securitycraft:blacklist_module", "securitycraft:whitelist_module");

    private DataFixHandler() {
    }

    public static void fix(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        if (itemStackData.is("securitycraft:briefcase")) {
            DataFixHandler.fixBriefcase(itemStackData, dynamic);
        }
        if (itemStackData.is(KEYCARD_HOLDER_OR_DISGUISE_MODULE)) {
            DataFixHandler.fixItemInventory(itemStackData, dynamic);
        }
        if (itemStackData.is(KEYCARDS)) {
            DataFixHandler.fixKeycard(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:codebreaker")) {
            DataFixHandler.fixCodebreaker(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:camera_monitor")) {
            DataFixHandler.fixCameraMonitor(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:remote_access_mine")) {
            DataFixHandler.fixMineRemoteAccessTool(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:remote_access_sentry")) {
            DataFixHandler.fixSentryRemoteAccessTool(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:sonic_security_system")) {
            DataFixHandler.fixSonicSecuritySystem(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:portable_tune_player")) {
            DataFixHandler.fixPortableTunePlayer(itemStackData, dynamic);
        }
        if (itemStackData.is(REINFORCERS)) {
            DataFixHandler.fixReinforcers(itemStackData, dynamic);
        }
        if (itemStackData.is(LIST_MODULES)) {
            DataFixHandler.fixListModule(itemStackData, dynamic);
        }
        if (itemStackData.is("securitycraft:disguise_module")) {
            DataFixHandler.fixDisguiseModule(itemStackData, dynamic);
        }
    }

    public static void registerBlockEntities(Schema schema, Map<String, Supplier<TypeTemplate>> map) {
        String[] hasOnlyModules;
        for (String blockEntityType : hasOnlyModules = new String[]{"securitycraft:alarm", "securitycraft:reinforced_pressure_plate", "securitycraft:abstract", "securitycraft:disguisable", "securitycraft:cage_trap", "securitycraft:floor_trap", "securitycraft:keycard_reader", "securitycraft:keycard_lock", "securitycraft:keypad", "securitycraft:protecto", "securitycraft:ownable", "securitycraft:retinal_scanner", "securitycraft:rift_stabilizer", "securitycraft:username_logger", "securitycraft:ims", "securitycraft:keypad_trapdoor", "securitycraft:key_panel", "securitycraft:keypad_door", "securitycraft:scanner_door", "securitycraft:motion_light", "securitycraft:portable_radar", "securitycraft:reinforced_cauldron", "securitycraft:scanner_trapdoor", "securitycraft:sonic_security_system", "securitycraft:secret_hanging_sign", "securitycraft:secret_sign", "securitycraft:secure_redstone_interface"}) {
            DataFixHandler.registerModules(schema, map, blockEntityType);
        }
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:keypad_chest");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:keypad_furnace");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:keypad_blast_furnace");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:keypad_smoker");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:keypad_barrel");
        schema.register(map, "securitycraft:inventory_scanner", () -> DSL.optionalFields((String)"Modules", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)), (String)"Items", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)), (String)"lens", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema))));
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:block_pocket_manager");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:reinforced_hopper");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:reinforced_dropper");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:reinforced_dispenser");
        DataFixHandler.registerSingleItemAndModules(schema, map, "securitycraft:reinforced_lectern", "Book");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:reinforced_chiseled_bookshelf");
        DataFixHandler.registerSingleItemAndModules(schema, map, "securitycraft:block_change_detector", "filter");
        DataFixHandler.registerSingleItemAndModules(schema, map, "securitycraft:projector", "storedItem");
        schema.register(map, "securitycraft:laser_block", () -> DSL.allWithRemainder((TypeTemplate)DSL.optional((TypeTemplate)DSL.field((String)"Modules", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)))), (TypeTemplate[])new TypeTemplate[]{DSL.optional((TypeTemplate)DSL.field((String)"lens0", (TypeTemplate)References.ITEM_STACK.in(schema))), DSL.optional((TypeTemplate)DSL.field((String)"lens1", (TypeTemplate)References.ITEM_STACK.in(schema))), DSL.optional((TypeTemplate)DSL.field((String)"lens2", (TypeTemplate)References.ITEM_STACK.in(schema))), DSL.optional((TypeTemplate)DSL.field((String)"lens3", (TypeTemplate)References.ITEM_STACK.in(schema))), DSL.optional((TypeTemplate)DSL.field((String)"lens4", (TypeTemplate)References.ITEM_STACK.in(schema))), DSL.optional((TypeTemplate)DSL.field((String)"lens5", (TypeTemplate)References.ITEM_STACK.in(schema)))}));
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:security_camera", "lens");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:trophy_system", "lens");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:claymore", "lens");
        DataFixHandler.registerSingleItemAndModules(schema, map, "securitycraft:display_case", "DisplayedStack");
        DataFixHandler.registerSingleItemAndModules(schema, map, "securitycraft:glow_display_case", "DisplayedStack");
    }

    public static void registerEntities(Schema schema, Map<String, Supplier<TypeTemplate>> map) {
        schema.registerSimple(map, "securitycraft:bouncingbetty");
        schema.registerSimple(map, "securitycraft:imsbomb");
        schema.registerSimple(map, "securitycraft:securitycamera");
        schema.register(map, "securitycraft:sentry", () -> DSL.optionalFields((String)"InstalledWhitelist", (TypeTemplate)References.ITEM_STACK.in(schema), (String)"InstalledModule", (TypeTemplate)References.ITEM_STACK.in(schema)));
        schema.registerSimple(map, "securitycraft:bullet");
        DataFixHandler.registerInventoryAndModules(schema, map, "securitycraft:security_sea_boat");
    }

    private static void fixBriefcase(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        String passcode = itemStackData.removeTag("passcode").asString("");
        IntStream saltKey = itemStackData.removeTag("saltKey").asIntStream();
        if (!passcode.isEmpty()) {
            itemStackData.setComponent("securitycraft:passcode_data", dynamic.emptyMap().set("passcode", dynamic.createString(passcode)).set("salt_key", dynamic.createIntList(saltKey)));
        }
        DataFixHandler.fixOwner(itemStackData, dynamic, "owner", true);
        DataFixHandler.fixItemInventory(itemStackData, dynamic);
    }

    private static void fixItemInventory(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        List list = dynamic.get("ItemInventory").asList(d -> d.emptyMap().set("slot", d.createInt(d.get("Slot").asByte((byte)0) & 0xFF)).set("item", d.remove("Slot")));
        if (!list.isEmpty()) {
            itemStackData.setComponent("minecraft:container", dynamic.createList(list.stream()));
        }
        itemStackData.removeTag("ItemInventory");
    }

    private static void fixKeycard(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        if (itemStackData.removeTag("linked").asBoolean(false)) {
            int signature = itemStackData.removeTag("signature").asInt(KeycardData.DEFAULT.signature());
            boolean limited = itemStackData.removeTag("limited").asBoolean(KeycardData.DEFAULT.limited());
            int usesLeft = itemStackData.removeTag("uses").asInt(KeycardData.DEFAULT.usesLeft());
            itemStackData.setComponent("securitycraft:keycard_data", dynamic.emptyMap().set("signature", dynamic.createInt(signature)).set("limited", dynamic.createBoolean(limited)).set("uses_left", dynamic.createInt(usesLeft)));
            DataFixHandler.fixOwner(itemStackData, dynamic, "ownerName", false);
        }
    }

    private static void fixOwner(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic, String ownerKey, boolean showInTooltip) {
        String ownerName = itemStackData.removeTag(ownerKey).asString(OwnerData.DEFAULT.name());
        String ownerUUID = itemStackData.removeTag("ownerUUID").asString(OwnerData.DEFAULT.uuid());
        itemStackData.setComponent("securitycraft:owner", dynamic.emptyMap().set("name", dynamic.createString(ownerName)).set("uuid", dynamic.createString(ownerUUID)).set("show_in_tooltip", dynamic.createBoolean(showInTooltip)));
    }

    private static void fixCodebreaker(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        long lastUsedTime = itemStackData.removeTag("last_used_time").asLong(CodebreakerData.DEFAULT.lastUsedTime());
        boolean wasSuccessful = itemStackData.removeTag("was_successful").asBoolean(CodebreakerData.DEFAULT.wasSuccessful());
        itemStackData.setComponent("securitycraft:codebreaker_data", dynamic.emptyMap().set("last_used_time", dynamic.createLong(lastUsedTime)).set("was_successful", dynamic.createBoolean(wasSuccessful)));
    }

    private static void fixCameraMonitor(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        ArrayList<Dynamic> positions = new ArrayList<Dynamic>();
        for (int i = 1; i <= 30; ++i) {
            String[] data;
            Optional camera = itemStackData.removeTag("Camera" + i).result();
            if (camera.isPresent() && (data = ((Dynamic)camera.get()).asString("").split(" ")).length >= 3) {
                int x = Integer.parseInt(data[0]);
                int y = Integer.parseInt(data[1]);
                int z = Integer.parseInt(data[2]);
                String dimension = data.length == 4 ? data[3] : "minecraft:overworld";
                positions.add(dynamic.emptyMap().set("dimension", dynamic.createString(dimension)).set("pos", dynamic.createIntList(IntStream.of(x, y, z))));
                continue;
            }
            positions.add(dynamic.emptyMap());
        }
        if (!positions.isEmpty()) {
            itemStackData.setComponent("securitycraft:bound_cameras", dynamic.emptyMap().set("positions", dynamic.createList(positions.stream())));
        }
    }

    private static void fixMineRemoteAccessTool(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        ArrayList<Dynamic> positions = new ArrayList<Dynamic>();
        for (int i = 1; i <= 6; ++i) {
            Optional mine = itemStackData.removeTag("mine" + i).result();
            if (mine.isPresent()) {
                positions.add(dynamic.emptyMap().set("dimension", dynamic.createString("minecraft:overworld")).set("pos", (Dynamic)mine.get()));
                continue;
            }
            positions.add(dynamic.emptyMap());
        }
        if (!positions.isEmpty()) {
            itemStackData.setComponent("securitycraft:bound_mines", dynamic.emptyMap().set("positions", dynamic.createList(positions.stream())));
        }
    }

    private static void fixSentryRemoteAccessTool(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        ArrayList<Dynamic> positions = new ArrayList<Dynamic>();
        for (int i = 1; i <= 12; ++i) {
            Optional sentry = itemStackData.removeTag("sentry" + i).result();
            if (sentry.isPresent()) {
                Dynamic entry = dynamic.emptyMap().set("global_pos", dynamic.emptyMap().set("dimension", dynamic.createString("minecraft:overworld")).set("pos", (Dynamic)sentry.get()));
                Optional sentryName = itemStackData.removeTag("sentry" + i + "_name").result();
                if (sentryName.isPresent()) {
                    entry = entry.set("name", (Dynamic)sentryName.get());
                }
                positions.add(entry);
                continue;
            }
            positions.add(dynamic.emptyMap());
        }
        if (!positions.isEmpty()) {
            itemStackData.setComponent("securitycraft:bound_sentries", dynamic.emptyMap().set("positions", dynamic.createList(positions.stream())));
        }
    }

    private static void fixSonicSecuritySystem(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        ArrayList<Dynamic> linkedBlocks = new ArrayList<Dynamic>(dynamic.get("LinkedBlocks").asList(d -> d.emptyMap().set("dimension", d.createString("minecraft:overworld")).set("pos", d.createIntList(IntStream.of(d.get("X").asInt(0), d.get("Y").asInt(0), d.get("Z").asInt(0))))));
        int linkedBlocksCount = linkedBlocks.size();
        int maxCount = 30;
        if (linkedBlocksCount < 30) {
            for (int i = linkedBlocksCount; i < 30; ++i) {
                linkedBlocks.add(dynamic.emptyMap());
            }
        } else if (linkedBlocksCount > 30) {
            linkedBlocks = new ArrayList(linkedBlocks.subList(0, 30));
        }
        if (!linkedBlocks.isEmpty()) {
            itemStackData.setComponent("securitycraft:sss_linked_blocks", dynamic.emptyMap().set("positions", dynamic.createList(linkedBlocks.stream())));
        }
        itemStackData.removeTag("LinkedBlocks");
    }

    private static void fixPortableTunePlayer(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        List notes = dynamic.get("Notes").asList(d -> d.emptyMap().set("id", d.createInt(d.get("noteID").asInt(0))).set("instrument", d.createString(d.get("instrument").asString(""))).set("custom_sound", d.createString(d.get("customSoundId").asString(""))));
        if (!notes.isEmpty()) {
            itemStackData.setComponent("securitycraft:notes", dynamic.emptyMap().set("notes", dynamic.createList(notes.stream())));
        }
        itemStackData.removeTag("Notes");
    }

    private static void fixReinforcers(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        Optional isUnreinforcing = itemStackData.removeTag("is_unreinforcing").result();
        if (isUnreinforcing.isPresent()) {
            itemStackData.setComponent("securitycraft:unreinforcing", dynamic.emptyMap());
        }
    }

    private static void fixListModule(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        ArrayList<Dynamic> players = new ArrayList<Dynamic>();
        List teams = itemStackData.removeTag("ListedTeams").asList(d -> d);
        boolean affectEveryone = itemStackData.removeTag("affectEveryone").asBoolean(false);
        for (int i = 1; i <= 50; ++i) {
            Optional player = itemStackData.removeTag("Player" + i).result();
            if (!player.isPresent()) continue;
            players.add((Dynamic)player.get());
        }
        if (!players.isEmpty() || !teams.isEmpty() || affectEveryone) {
            itemStackData.setComponent("securitycraft:list_module_data", dynamic.emptyMap().set("players", dynamic.createList(players.stream())).set("teams", dynamic.createList(teams.stream())).set("affect_everyone", dynamic.createBoolean(affectEveryone)));
        }
    }

    private static void fixDisguiseModule(ItemStackComponentizationFix.ItemStackData itemStackData, Dynamic<?> dynamic) {
        Optional state = itemStackData.removeTag("SavedState").result();
        if (state.isPresent()) {
            int standingOrWall = Math.min(itemStackData.removeTag("StandingOrWall").asInt(0), StandingOrWallType.values().length - 1);
            itemStackData.setComponent("securitycraft:saved_block_state", dynamic.emptyMap().set("state", (Dynamic)state.get()).set("standing_or_wall_type", dynamic.createString(StandingOrWallType.values()[standingOrWall].getSerializedName())));
        }
    }

    private static void registerModules(Schema schema, Map<String, Supplier<TypeTemplate>> map, String type) {
        schema.register(map, type, () -> DSL.optionalFields((String)"Modules", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema))));
    }

    private static void registerSingleItemAndModules(Schema schema, Map<String, Supplier<TypeTemplate>> map, String type, String itemKey) {
        schema.register(map, type, name -> DSL.optionalFields((String)itemKey, (TypeTemplate)References.ITEM_STACK.in(schema), (String)"Modules", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema))));
    }

    private static void registerInventoryAndModules(Schema schema, Map<String, Supplier<TypeTemplate>> map, String type) {
        DataFixHandler.registerInventoryAndModules(schema, map, type, "Items");
    }

    private static void registerInventoryAndModules(Schema schema, Map<String, Supplier<TypeTemplate>> map, String type, String key) {
        schema.register(map, type, () -> DSL.optionalFields((String)key, (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema)), (String)"Modules", (TypeTemplate)DSL.list((TypeTemplate)References.ITEM_STACK.in(schema))));
    }
}

